/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.autoplot.AutoplotUtil;
import org.autoplot.ScriptContext;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.jythonsupport.Util;
import org.autoplot.state.StatePersistence;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.system.DefaultMonitorFactory;
import org.das2.system.MonitorFactory;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.HtmlUtil;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.xml.sax.SAXException;

public class Test140 {
    private static int testid;

    private static String getUniqueFilename(String name, String ext, boolean append) {
        File ff = new File(name + ext);
        while (ff.exists()) {
            name = name + "_";
            ff = new File(name + ".png");
        }
        if (append) {
            return name + ext;
        }
        return name;
    }

    private static void listAllPendingTasks() {
        MonitorFactory mf = ScriptContext.getDocumentModel().getController().getMonitorFactory();
        if (mf instanceof DefaultMonitorFactory) {
            DefaultMonitorFactory.MonitorEntry[] mes;
            DefaultMonitorFactory dmf = (DefaultMonitorFactory)mf;
            for (DefaultMonitorFactory.MonitorEntry me : mes = dmf.getMonitors()) {
                ProgressMonitor m = me.getMonitor();
                if (m.isCancelled() || m.isFinished()) continue;
                System.err.println(m);
            }
        }
    }

    private static String do1(String uri, int iid, boolean doTest, boolean isPublic) throws Exception {
        return Test140.do1(uri, "", iid, doTest, isPublic);
    }

    private static String do1(String uri, String shortId, int iid, boolean doTest, boolean isPublic) throws Exception {
        String result;
        String name;
        Object dom;
        System.err.printf("== %03d %03d %s ==\n", testid, iid, shortId);
        if (isPublic) {
            System.err.printf("uri: %s\n", uri);
        } else {
            System.err.printf("uri: (uri is not public)\n", new Object[0]);
        }
        String label = shortId.length() > 0 ? String.format("test%03d_%s", testid, shortId) : String.format("test%03d_%03d", testid, iid);
        long t0 = System.currentTimeMillis();
        double tsec = t0;
        double psec = t0;
        QDataSet ds = null;
        if (uri.endsWith(".vap") || uri.contains(".vap?timerange=")) {
            if (isPublic) {
                URISplit split = URISplit.parse((String)uri);
                try (InputStream in = DataSetURI.getInputStream((URI)split.resourceUri, (ProgressMonitor)new NullProgressMonitor());){
                    dom = StatePersistence.restoreState(in, URISplit.parseParams((String)split.params));
                    for (DataSourceFilter dsf : ((Application)dom).getDataSourceFilters()) {
                        System.err.printf("  %s: %s\n", dsf.getId(), dsf.getUri());
                    }
                    System.err.println("  timerange: " + ((Application)dom).getTimeRange());
                }
            }
            ScriptContext.load(uri);
            ds = ScriptContext.getDocumentModel().getDataSourceFilters(0).getController().getDataSet();
            tsec = (double)(System.currentTimeMillis() - t0) / 1000.0;
            if (ds == null) {
                throw new IllegalArgumentException("a dataset from the vap was null: " + uri);
            }
            MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)ds);
            hist.putProperty("LABEL", (Object)label);
            ScriptContext.formatDataSet((QDataSet)hist, Test140.getUniqueFilename(label, ".qds", true));
            psec = (double)(System.currentTimeMillis() - t0) / 1000.0;
        } else if (uri.startsWith("script:")) {
            System.err.println("skipping script");
        } else if (uri.startsWith("bookmarks:")) {
            System.err.println("skipping bookmarks");
        } else if (uri.startsWith("pngwalk:")) {
            System.err.println("skipping pngwalk");
        } else {
            String fileUri;
            ds = Util.getDataSet((String)uri);
            tsec = (double)(System.currentTimeMillis() - t0) / 1000.0;
            if (ds != null) {
                if (isPublic) {
                    QDataSet dep0;
                    Units u = SemanticOps.getUnits((QDataSet)ds);
                    if (!UnitsUtil.isNominalMeasurement((Units)u)) {
                        MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)ds);
                        hist.putProperty("TITLE", (Object)uri);
                        hist.putProperty("LABEL", (Object)label);
                        ScriptContext.formatDataSet((QDataSet)hist, label + ".qds");
                    }
                    if ((dep0 = (QDataSet)ds.property("DEPEND_0")) != null) {
                        MutablePropertyDataSet hist2 = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)dep0);
                        ScriptContext.formatDataSet((QDataSet)hist2, label + ".dep0.qds");
                    } else {
                        PrintWriter pw = new PrintWriter(label + ".dep0.qds");
                        dom = null;
                        try {
                            pw.println("no dep0");
                        }
                        catch (Throwable throwable) {
                            dom = throwable;
                            throw throwable;
                        }
                        finally {
                            if (pw != null) {
                                if (dom != null) {
                                    try {
                                        pw.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)dom).addSuppressed(throwable);
                                    }
                                } else {
                                    pw.close();
                                }
                            }
                        }
                    }
                } else {
                    System.err.println("TODO Turkey: Make a hash of the .qds of the data");
                }
                Test140.listAllPendingTasks();
                ScriptContext.reset();
                ScriptContext.plot(ds);
                ScriptContext.setCanvasSize(450, 300);
                ScriptContext.getDocumentModel().getOptions().setCanvasFont("sans-10");
                ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setLeft("5.0em");
                ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100.00%-10.0em");
                int i = uri.lastIndexOf("/");
                ScriptContext.getApplicationModel().waitUntilIdle();
                fileUri = uri.substring(i + 1);
                if (!ScriptContext.getDocumentModel().getPlotElements(0).getComponent().equals("")) {
                    String dsstr = String.valueOf(ScriptContext.getDocumentModel().getDataSourceFilters(0).getController().getDataSet());
                    fileUri = fileUri + " " + dsstr + " " + ScriptContext.getDocumentModel().getPlotElements(0).getComponent();
                }
            } else {
                throw new IllegalArgumentException("uri results in null dataset: " + uri);
            }
            ScriptContext.setTitle(fileUri);
            psec = (double)(System.currentTimeMillis() - t0) / 1000.0;
        }
        if (isPublic) {
            System.err.println("dataset: " + ds);
        } else {
            System.err.println("dataset: (data is not public)");
        }
        if (doTest) {
            String id;
            if (shortId.length() == 0) {
                id = URLEncoder.encode(uri, "US-ASCII");
                id = id.replaceAll("%3A", "");
                id = id.replaceAll("%2F%2F", "_");
                if ((id = id.replaceAll("%[0-9A-F][0-9A-F]", "_")).length() > 150) {
                    id = id.substring(0, 150) + "..." + String.format("%016d", id.hashCode());
                }
                if (!isPublic) {
                    id = String.format("%08x", id.hashCode());
                }
            } else {
                id = shortId;
            }
            result = name = String.format("test%03d_%s", testid, id);
        } else {
            name = String.format("ex_test%03d_%03d", testid, iid);
            result = null;
        }
        String name1 = Test140.getUniqueFilename(name, ".png", true);
        if (isPublic) {
            ScriptContext.writeToPng(name1);
        } else {
            ScriptContext.writeToPng("/home/jbf/ct/hudson/private/test/" + name1);
            int width = ScriptContext.getApplicationModel().getDom().getController().getCanvas().getWidth();
            int height = ScriptContext.getApplicationModel().getDom().getController().getCanvas().getHeight();
            BufferedImage image = ScriptContext.getApplicationModel().getDom().getController().getCanvas().getController().getDasCanvas().getImage(width, height);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", outputStream);
            byte[] data = outputStream.toByteArray();
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(data);
            byte[] hash = md.digest();
            try (PrintStream bout = new PrintStream(new FileOutputStream(Test140.getUniqueFilename(name, ".txt", true)));){
                for (byte b : hash) {
                    bout.println(String.format("%03d", b));
                }
            }
        }
        if (isPublic) {
            System.err.printf("wrote to file: %s\n", name1);
            System.err.printf("Read in %9.3f seconds (%s): %s\n", tsec, label, uri);
            System.err.printf("Plot in %9.3f seconds (%s): %s\n", psec, label, uri);
        } else {
            System.err.printf("wrote to file: %s\n", "/home/jbf/ct/hudson/private/test/" + name1);
            System.err.printf("Read in %9.3f seconds (%s): %s\n", tsec, label, "(uri is not public)");
            System.err.printf("Plot in %9.3f seconds (%s): %s\n", psec, label, "(uri is not public)");
        }
        if (uri.endsWith(".vap") || uri.contains(".vap?timerange=")) {
            ScriptContext.reset();
            ScriptContext.getDocumentModel().getOptions().setColor(Color.BLACK);
            ScriptContext.getDocumentModel().getOptions().setBackground(Color.WHITE);
        }
        return result;
    }

    private static int doBookmarks(File f, int iid, Map<String, Exception> exceptions, Map<String, Integer> exceptionNumbers) throws IOException, SAXException, BookmarksException {
        List<Bookmark> books = Bookmark.parseBookmarks(f.toURI().toURL());
        return Test140.doBookmarks(books, iid, exceptions, exceptionNumbers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doBookmarks(List<Bookmark> books, int iid, Map<String, Exception> exceptions, Map<String, Integer> exceptionNumbers) throws IOException, SAXException, BookmarksException {
        for (Bookmark b : books) {
            boolean hidden = b.isHidden();
            if (!hidden) {
                if (b instanceof Bookmark.Folder) {
                    if (((Bookmark.Folder)b).getRemoteUrl() != null) {
                        System.err.println("Skipping remote bookmarks file " + ((Bookmark.Folder)b).getRemoteUrl());
                        continue;
                    }
                    iid = Test140.doBookmarks(((Bookmark.Folder)b).getBookmarks(), iid, exceptions, exceptionNumbers);
                    continue;
                }
                String uri = ((Bookmark.Item)b).getUri();
                try {
                    Test140.do1(uri, iid, true, true);
                    continue;
                }
                catch (Exception ex) {
                    exceptions.put(uri, ex);
                    continue;
                }
                finally {
                    ++iid;
                    continue;
                }
            }
            if (b instanceof Bookmark.Folder) {
                System.err.println("Skipping hidden bookmark: \n\t" + b.getTitle() + "\n\t" + b.getDescription());
                continue;
            }
            if (!(b instanceof Bookmark.Item)) continue;
            System.err.println("Skipping hidden bookmark: \n\t" + ((Bookmark.Item)b).getUri() + "\n\t" + b.getTitle() + "\n\t" + b.getDescription());
            ++iid;
        }
        return iid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doHtml(URL url, int iid, Map<String, Exception> exceptions, Map<String, Integer> exceptionNumbers) throws IOException, CancelledOperationException {
        try (InputStream in = url.openStream();){
            URL[] urls = HtmlUtil.getDirectoryListing((URL)url, (InputStream)in, (boolean)false);
            ArrayList result = new ArrayList();
            ArrayList<String> sresult = new ArrayList<String>();
            for (URL url1 : urls) {
                if (!url1.getFile().endsWith(".vap") && !url1.getFile().contains("autoplot.jnlp?")) continue;
                String s = url1.toString();
                if (s.startsWith("http://autoplot.org/autoplot.jnlp?")) {
                    s = s.substring(34);
                }
                s = s.replaceAll(" ", "+");
                s = DataSourceUtil.unescape((String)s);
                sresult.add(s);
            }
            for (String suri : sresult) {
                try {
                    Test140.do1(suri, iid, true, true);
                }
                catch (Exception ex) {
                    exceptions.put(suri, ex);
                    exceptionNumbers.put(suri, iid);
                }
                finally {
                    ++iid;
                }
            }
            int n = iid;
            return n;
        }
    }

    private static boolean isURI(String s) {
        try {
            DataSetURI.getURIValid((String)s);
            URISplit split = URISplit.parse((String)s);
            if (split.vapScheme == null && split.scheme == null) {
                return false;
            }
        }
        catch (IllegalArgumentException | URISyntaxException ex) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doHistory(String historyFileUri, File f, int iid, Map<String, Exception> exceptions, Map<String, Integer> exceptionNumbers) throws IOException {
        String pwd = URISplit.parse((String)historyFileUri).path;
        try (BufferedReader read = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));){
            String s = read.readLine();
            System.err.println(">> doHistory " + s);
            while (s != null) {
                int i = s.indexOf(35);
                if (i > -1) {
                    s = s.substring(0, i);
                }
                if ((s = s.trim()).length() > 0) {
                    String[] ss = s.split("\t");
                    if (ss.length == 1 && !Test140.isURI(s)) {
                        ss = s.split("\\s");
                    }
                    String uri = ss[ss.length - 1].trim();
                    String shortId = "";
                    boolean publc = true;
                    if (ss.length > 1) {
                        boolean isPrivate = ss[ss.length - 2].trim().startsWith("x");
                        boolean bl = publc = !isPrivate;
                        if (isPrivate) {
                            if (ss.length > 2) {
                                shortId = ss[0];
                            }
                        } else {
                            shortId = ss[0];
                        }
                    }
                    if (uri.startsWith("x ")) {
                        uri = uri.substring(2).trim();
                        publc = false;
                    }
                    if (uri.startsWith("%{PWD}")) {
                        uri = pwd + uri.substring(6);
                    }
                    try {
                        Test140.do1(uri, shortId, iid, true, publc);
                    }
                    catch (Exception ex) {
                        exceptions.put(uri, ex);
                        exceptionNumbers.put(uri, iid);
                    }
                    finally {
                        ++iid;
                    }
                }
                s = read.readLine();
            }
            int n = iid;
            return n;
        }
    }

    public static void main(String[] args) throws Exception {
        System.err.println("disable certificate checking");
        AutoplotUtil.disableCertificates();
        System.err.println("home (prefs): " + System.getProperty("user.home"));
        System.err.println("autoplot_data: " + AutoplotSettings.settings().resolveProperty("autoplotData"));
        System.err.println("fscache: " + AutoplotSettings.settings().resolveProperty("fscache"));
        System.err.println("reading logger configuration from System.getProperty(\"java.util.logging.config.file\"): " + System.getProperty("java.util.logging.config.file"));
        LoggerManager.readConfiguration();
        if (args.length == 0) {
            args = new String[]{"000", "/home/jbf/ct/autoplot/git/dev/bugs/sf/1682/testuris.txt"};
        }
        testid = Integer.parseInt(args[0]);
        int iid = 0;
        LinkedHashMap<String, Exception> exceptions = new LinkedHashMap<String, Exception>();
        LinkedHashMap<String, Integer> exceptionNumbers = new LinkedHashMap<String, Integer>();
        ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
        for (int i = 1; i < args.length; ++i) {
            File ff;
            String uri = args[i];
            System.err.println("\n=======================");
            System.err.println("== from " + uri);
            System.err.println("=======================\n");
            if (uri.endsWith(".xml")) {
                ff = DataSetURI.getFile((String)uri, (ProgressMonitor)new NullProgressMonitor());
                iid = Test140.doBookmarks(ff, iid, exceptions, exceptionNumbers);
            } else if (uri.endsWith(".txt")) {
                ff = DataSetURI.getFile((String)uri, (ProgressMonitor)new NullProgressMonitor());
                iid = Test140.doHistory(uri, ff, iid, exceptions, exceptionNumbers);
            } else {
                iid = Test140.doHtml(new URL(uri), iid, exceptions, exceptionNumbers);
            }
            iid = ((iid + 1) / 100 + 1) * 100;
        }
        System.err.println("\n\n=== Exceptions encountered ==============");
        for (Map.Entry e : exceptions.entrySet()) {
            System.err.println(String.format("== %4d: %s ==", exceptionNumbers.get(e.getKey()), e.getKey()));
            ((Exception)e.getValue()).printStackTrace();
        }
        if (exceptions.isEmpty()) {
            System.err.println("(none)\n\n");
            System.exit(0);
        } else {
            System.err.println("(" + exceptions.size() + " exceptions)\n\n");
            System.exit(1);
        }
        System.err.println("\n\n==============");
    }
}

